function splitContributors(contextPath, fieldName, fieldInput, labelButtonAdd, bshare, bintord, baffil)
{
	splitContributors(contextPath, fieldName, null, fieldInput, labelButtonAdd, 100, bshare, bintord, baffil)
}

function splitContributors(contextPath, fieldName, affiliationInput, fieldInput, labelButtonAdd, size, bshare, bintord, baffil)
{
	var values = j(fieldName).val();
	var affvalues = null;
	if (affiliationInput != null) {
		affvalues = j(affiliationInput).val();
	}
	j('#splitcontributorsprogress').dialog("open");
	j.ajax({url: contextPath+"/json/contributors", 
		type: "POST",
		dataType: "json", 
		async: false,
		contentType: "application/x-www-form-urlencoded;charset=UTF-8", 
		data: ({allcontributors: values, allaffiliations: affvalues}), 
		error: function(info){j('#splitcontributorsprogress').dialog("close");},
		success: function(info) {
			j('#splitcontributorsprogress').dialog("close");
			if (info == null || info.allcontributors == '')
				return;
			j("#"+fieldInput.replace("dc_contributor_","dc_description_all")+"s_id").val(info.allcontributors);
			j("#"+fieldInput.replace("dc_contributor_","dc_description_all")+"s_id").change();
			var contributors = info.shareAuthorInfos;
			if (contributors != null && contributors.size() > 0)
			{
				j("#sharediv_"+fieldInput).remove("table#sharetable_"+fieldInput+" tbody"); 
				var rows =  j("#sharediv_"+fieldInput).find("table#sharetable_"+fieldInput);
				var html = "";
				for (var i = 0; i < contributors.size(); i++)
				{
					html += "<tr>";
					html += "<td>";
					var share = contributors[i].share;					
					var numInt = 0;
					j.each((contributors[i].authors),function(index,value){
						if(contributors[i].authors.length>1) {													
						var fullname = 	value.fullname;
						var authority = value.authority;
						if (authority != null)
						{
							numInt++;
						}
						if(index==0) {
							html += "<input type=\"hidden\" align=\"left\" size=\""+size+"\" id=\""+fieldInput+"_"+(i+1)+"\" name=\""+fieldInput+"_"+(i+1)+"\" value=\""+ fullname +"\"/>";
							html += "<select style=\"width:"+((size-1)/2)+"em\" id=\"select_"+fieldInput+"_"+(i+1)+"\" name=\"select_"+fieldInput+"_"+(i+1)+"\" onchange=\"fillContributor('"+fieldInput+"',"+(i+1)+",this.value)\">";
						}
						html += "<option value=\""+ index +"_"+ fullname +"_"+ (authority!=null?authority:"") +"_"+ share +"_"+contributors[i].intOrd+"\">";
						html += value.display.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");
						html += "</option>";
						if(index==contributors[i].authors.length-1) {
							html += "</select>";
							if (numInt > 1)
							{
								html += '<img src="'+contextPath+'/image/business_male_female_users.png" border="0" style="vertical-align: bottom;"/>';
							}
						}
						
						}
						else {
							numInt = contributors[i].authors[0].authority != null?1:0;
							html += "<input type=\"text\" readonly=\"readonly\" align=\"left\" size=\""+size+"\" id=\""+fieldInput+"_"+(i+1)+"\" name=\""+fieldInput+"_"+(i+1)+"\" value=\""+contributors[i].authors[0].fullname+"\"/>";		
						}						
					});
					html += "<input type=\"hidden\" align=\"left\" size=\"10\" id=\""+fieldInput+"_confidence_"+(i+1)+"\" name=\""+fieldInput+"_confidence_"+(i+1)+"\" value=\""+(numInt>0?"accepted":"novalue")+"\"/>";

					if (affiliationInput != null && baffil) {
						html += "<br/><span id=\""+fieldInput+"_"+(i+1)+"_affiliationspan\">Affiliation:</span>";
						
						html += "<select style=\"width:"+(size/2-7.5)+"em\" id=\"select_"+fieldInput+"_affiliation_"+(i+1)+"\" name=\"select_"+fieldInput+"_affiliation_"+(i+1)+"\">";
						html += "<option value=\"other"+"_"+(i+1)+"\">";
						html += "Altro";
						html += "</option>";
						html += "</select>";
						html += "<input type=\"text\" align=\"left\" size=\""+(size-15)+"\" name=\""+fieldInput+"_affiliation_"+(i+1)+"\" id=\""+fieldInput+"_affiliation_"+(i+1)+"\" value=\"\"/>";
					}
					
					html += "<br/><br/></td>";
					html += "<td>";					
					html += "<input type=\"hidden\" align=\"left\" size=\"10\" id=\""+fieldInput+"_authority_"+(i+1)+"\" name=\""+fieldInput+"_authority_"+(i+1)+"\" value=\""; 
					if((contributors[i].authors[0].authority)==null){
						html += "\">";		
					}
					else {
						html += contributors[i].authors[0].authority;
						html += "\">";
					}
					html += "</td>";
					
					if (bshare)
					{
						html += "<td>";					
						html += "<input type=\"text\" align=\"left\" size=\"3\" id=\""+fieldInput+"_share_"+(i+1)+"\" name=\""+fieldInput+"_share_"+(i+1)+"\" value=\"";
						if((contributors[i].share)==null){
							html += 0;
							html += "\">";		
						}
						else {
							html += contributors[i].share;
							html += "\">";
						}
						html += "</td>";
					}
					var ordine = contributors[i].intOrd;
					if (bintord)
					{
						html += "<td>";					

					    html += "<select id=\""+fieldInput+"_intorder_"+(i+1)+"\" name=\""+fieldInput+"_intorder_"+(i+1)+"\">";
					    html += "<option value=\"-1\"";
					    if (ordine == -1) html += " selected=\"selected\"";
		 			    html += ">"+SUROA_I18N_SHAREPRIORITYFEATURE_INTORD_NOTSELECTED+"</option>";

		 			    html += "<option value=\"0\"";
		 			    if (ordine == 0) html += " selected=\"selected\"";
		 			    html += ">"+SUROA_I18N_SHAREPRIORITYFEATURE_INTORD_CORRESPONDING+"</option>";

		 			    html += "<option value=\"1\"";
		 			    if (ordine == 1) html += " selected=\"selected\"";
		 			    html += ">"+SUROA_I18N_SHAREPRIORITYFEATURE_INTORD_FIRST+"</option>";
		 			    
		 			    html += "<option value=\"2\"";
		 			    if (ordine == 2) html += " selected=\"selected\"";
		 			    html += ">"+SUROA_I18N_SHAREPRIORITYFEATURE_INTORD_SECOND+"</option>";
		 			    
			   			html += "<option value=\"999\"";
		 			    if (ordine == 999) html += " selected=\"selected\"";
		 			    html += ">"+SUROA_I18N_SHAREPRIORITYFEATURE_INTORD_LAST+"</option>";
		 			    
		 			    html += "</select>";
		 			    html += "</td>";
	 			    }
						
					if(i==0) {
						html += "<td rowspan=\""+contributors.size()+"\">";					
						html += "<input type=\"submit\" name=\"submit_"+fieldInput+"_add\" value=\""+ labelButtonAdd +"\"/>";					
						html += "</td>";
					}
					html += "</tr>";
				}
				j("#sharetbody_"+fieldInput).html(html);
				j("#sharetbody_"+fieldInput).find('input[type="text"]').keydown(function(){return false;});
				if (affiliationInput != null) {
					if (contributors != null && contributors.size()>0)
					{
						for (var i = 0; i < contributors.size(); i++)
						{
							j("#"+fieldInput+"_"+(i+1)).data('authorsinfo', contributors[i].authors);
							var iname = j("#select_"+fieldInput+"_"+(i+1));
							if (iname.length == 0)
							{
								iname = j("#"+fieldInput+"_"+(i+1));		
							}
							j("#"+fieldInput+"_affiliation_"+(i+1)).hide();
							j("#select_"+fieldInput+"_affiliation_"+(i+1)).position({my: "right top",at: "right bottom",of: iname});
							j("#select_"+fieldInput+"_affiliation_"+(i+1)).offset({top: j("#"+fieldInput+"_"+(i+1)+"_affiliationspan").offset().top-2,
									left: j("#select_"+fieldInput + "_affiliation_" +(i+1)).offset().left});
							populateAffiliations(fieldInput, i+1, 0);
						}
					}
				}
				j("#sharetable_"+fieldInput).effect('highlight',null,5000);
				if (j('#msgSplitFeature_'+fieldInput).size() == 0)
				{
					var alertMsg = j('<div class="ui-widget" id="msgSplitFeature_'+fieldInput+'" style="white-space: normal;" />');
					alertMsg.html(
							j('<div class="ui-state-highlight ui-corner-all" style="margin-top: 20px; padding: 0 .7em;" />').
							html(
									j('<p/>').html('<span class="ui-icon ui-icon-info" style="float: left; margin-right: .3em;"></span>'+SUROA_I18N_SUBMIT_SPLITCONTRIBUTORS)
							)
						).insertBefore(j("#sharetable_"+fieldInput));
				}
				j.scrollTo((j('#msgSplitFeature_'+fieldInput)));
			}
		}
	});
}

function fillContributor(fieldInput,fieldInputIndex,valueOption) {

	var substr = valueOption.split('_');
	var indexOption = substr[0];
	var fullname = substr[1];
	var authority = substr[2]=="undefined"?"":substr[2];
	var share = substr[3]=="undefined"?0:substr[3];
	var intorder = substr[4]=="undefined"?"":substr[4];
	var dc_contributor_author = "#"+fieldInput+"_"+fieldInputIndex;
	j(dc_contributor_author).val(fullname);	
	var dc_contributor_author_authority = "#"+fieldInput+"_authority_"+fieldInputIndex;
	j(dc_contributor_author_authority).val(authority);
	var dc_contributor_author_confidence = "#"+fieldInput+"_confidence_"+fieldInputIndex;
	j(dc_contributor_author_confidence).val(authority!=""&&authority!=null?'accepted':'novalue');
	var dc_contributor_author_share = "#"+fieldInput+"_share_"+fieldInputIndex;
	j(fieldInput+"_share_"+fieldInputIndex).val(share);
	var dc_contributor_author_intorder = "#"+fieldInput+"_intorder_"+fieldInputIndex;
	j(dc_contributor_author_intorder).val(intorder);
	
}

function populateAffiliations(fieldInput, fieldInputIndex, authorIdx)
{
	var input_affiliation = "#"+fieldInput+"_affiliation_"+fieldInputIndex;
	var select_affiliation = "#select_"+fieldInput+"_affiliation_"+fieldInputIndex;
	var authorinfo = j("#"+fieldInput+"_"+fieldInputIndex).data('authorsinfo');
	if (authorinfo != null && authorIdx < authorinfo.length)
	{
		var auth = authorinfo[authorIdx];
		var affiliations = auth.affiliations;
		if (affiliations == null || affiliations.length <= 1)
		{

			var top = j(select_affiliation).offset().top;
			var left = j(select_affiliation).offset().left;
			var swidth = j(select_affiliation).width();
			j(select_affiliation).hide();
			j(input_affiliation).show();
			var iwidth = j(input_affiliation).width();
			j(input_affiliation).offset({top: top, left: left+swidth-iwidth-4});
			if (affiliations != null && affiliations[0] != null)
			{
				j(input_affiliation).val(affiliations[0]);	
			}
			else
			{
				j(input_affiliation).val('');	
			}
		}
		else
		{
			var totaff = "";
			for (var i = 0; i < affiliations.length; i++)
			{
				if (i != 0)
				{
					totaff += "|||";
				}
				totaff += affiliations[i];
			}
			totaffhtml = totaff.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");
			j(input_affiliation).val(totaff);
			j(input_affiliation).hide();
			j(select_affiliation).html('');
			j(select_affiliation).append('<option value="'+totaffhtml+'" selected="selected">'+SUROA_I18N_SHAREPRIORITYFEATURE_SELECT_AFF+'</option>');
			for (var i = 0; i < affiliations.length; i++)
			{
				var affhtml = affiliations[i].replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");
				j(select_affiliation).append('<option value="'+affhtml+'">'+affhtml+'</option>');
			}
			j(select_affiliation).append('<option value="other">'+SUROA_I18N_SHAREPRIORITYFEATURE_OTHER_AFF+'</option>');
			j(select_affiliation).change(function(){fillAffiliation(this)});
		}
	}
}

function fillAffiliation(select){
	var val = j(select).val();
	var sid = '#'+j(select).attr('id').substring("select_".length);
	var selectid = '#'+j(select).attr('id');
	if ("other" == val)
	{
		var width = j(selectid).width();
		j(selectid).data('width', width);
		j(sid).val('');
		j(sid).show();
		j(sid).unbind('keydown');
		j(selectid).width('10em');
		j(sid).position({my: "left top", at: "right top", of: selectid});
		j(sid).width(width-6-j(selectid).width());
		j(sid).focus();
	}
	else
	{
		j(sid).hide();
		j(sid).val(val);
		j(selectid).width(j(selectid).data('width'));
	}
}

function groupContributors(fieldName) {
	
	var results = "";
	var rows = j("#sharediv_"+fieldName).find("table#sharetable_"+fieldName+" tbody tr");
	
	j.each(rows,function(index,value){
				
		var count = j(rows).find("td:first input[value!='']").length;
		var input = j(this).find("td:first input");
		
		if(input!=null && input.length>0) {
		if(j(input).val().length>0) {
			
			myregexp = new RegExp("^[\\w|\\W]+,\\s\\w");
			var mymatch = myregexp.exec(j(input).val());
			if(mymatch==null) {
				results += j(input).val();
			}
			else {		
				//double substitutions
				results += mymatch[0].toLowerCase().replace(/^(.)|\s(.)/g, function($1){ return $1.toUpperCase( ); }).replace(/-(.)|'(.)/g, function($1){ return $1.toUpperCase( ); });	
			}
			if(index!=count-1) {
				results += "; ";		
			}
		}
		}
	});
	j(fieldName).val(results);
	j(fieldName).change();
}

function recalculateShare(fieldName) {
	var rows = j("#sharediv_"+fieldName).find("table#sharetable_"+fieldName+" tbody tr");
	var count = j(rows).find("td:first input.ui-autocomplete-input[value!='']").length;
	
	var data = j(rows).find("td:eq(1) input");
	var diffShare = 0;
	var intShare = Math.floor(100/count);
	diffShare = 100-(count*intShare);
	
	j.each(data,function(index,value) {
		var firstInput = j(value).parent().parent().children().get(0).firstChild;
		if(j(firstInput).val().length>0) {
			j(value).val(intShare);					
			if(index<diffShare) {			
				j(value).val(intShare + 1);	
			}
		}
		else {
			j(value).val("");
		}
	});
	
}

function recalculateIntOrder(fieldName) {
	var rows = j("#sharediv_"+fieldName).find("table#sharetable_"+fieldName+" tbody tr");
	var data = j(rows).find("td:eq(2) input");
	var counter = 1;
	j.each(data,function(index,value){		
		var firstInput = j(value).parent().parent().children().get(0).firstChild;
		if(j(firstInput).val().length>0) {			
			j(value).val(counter);
			counter++;
		}					
		else {
			j(value).val("");
		}
	});
}

function autorivari(hint)
{
	var nomesharetbl = j(hint).attr('id').replace('autorivari','sharetbody');
	var inrow = j('#'+nomesharetbl).parents('tr:first').find('table tr:eq(3)')	
	inrow.find('input[type="text"]:first').val('AA.VV.');
	inrow.find('input[type="text"]:not(:first)').val('');
	inrow.find('input[type="hidden"]:first').val('AA.VV.');
	inrow.find('img').attr('class','ds-authority-confidence cf-blank');
	var otherrow = inrow.parents('table:first').find('tr:not(:eq(3))');
	otherrow.find('input[type="text"]:first').val('');
	otherrow.find('input[type="text"]:not(:first)').val('');
	otherrow.find('input[type="hidden"]:first').val('');
	otherrow.find('img').attr('class','ds-authority-confidence cf-blank');
	return false;
}

function orderUpAndDown(fieldInput,fieldName,fieldPosition,fieldNewPosition) {

	  //autocomplete				  
	  var tmp_id = j("#id_" + fieldInput).val();
	  var tmp_prev_id = j("#id_" + fieldName + "_" + fieldNewPosition).val();
	  //element server
	  var tmp_server = j("#"+fieldInput).val();
	  var tmp_prev_server = j("#"+fieldName + "_" + fieldNewPosition).val();
	  //authority
	  var tmp_authority = j("#"+fieldName +"_authority_" + fieldPosition).val();
	  var tmp_prev_authority = j("#"+fieldName +"_authority_" + fieldNewPosition).val();
	  //confidence
	  var tmp_confidence = j("#"+fieldName +"_confidence_" + fieldPosition).val();
	  var tmp_prev_confidence = j("#"+fieldName +"_confidence_" + fieldNewPosition).val();
	  //confidence indicator
	  var tmp_confidence_indicator = j("#"+fieldInput +"_confidence_indicator_id").attr("class");
	  var tmp_prev_confidence_indicator = j("#"+fieldName + "_" + fieldNewPosition +"_confidence_indicator_id").attr("class");				  
	  //share
	  var tmp_share = j("#"+fieldName +"_share_" + fieldPosition).val();
	  var tmp_prev_share = j("#"+fieldName +"_share_" + fieldNewPosition).val();
	  //intorder
	  var tmp_intorder = j("#"+fieldName +"_intorder_" + fieldPosition).val();
	  var tmp_prev_intorder = j("#"+fieldName +"_intorder_" + fieldNewPosition).val();

	  //autocomplete				  
	  j("#id_" + fieldInput).val(tmp_prev_id);
	  j("#id_" + fieldName + "_" + fieldNewPosition).val(tmp_id);
	  //element server
	  j("#"+fieldInput).val(tmp_prev_server);
	  j("#"+fieldName + "_" + fieldNewPosition).val(tmp_server);
	  //authority
	  j("#"+fieldName +"_authority_" + fieldPosition).val(tmp_prev_authority);
	  j("#"+fieldName +"_authority_" + fieldNewPosition).val(tmp_authority);
	  //confidence
	  j("#"+fieldName +"_confidence_" + fieldPosition).val(tmp_prev_confidence);
	  j("#"+fieldName +"_confidence_" + fieldNewPosition).val(tmp_confidence);
	  //confidence indicator
	  j("#"+fieldInput +"_confidence_indicator_id").removeClass(tmp_confidence_indicator).addClass(tmp_prev_confidence_indicator);
	  j("#"+fieldName + "_" + fieldNewPosition +"_confidence_indicator_id").removeClass(tmp_prev_confidence_indicator).addClass(tmp_confidence_indicator)				  
	  //share
	  j("#"+fieldName +"_share_" + fieldPosition).val(tmp_prev_share);
	  j("#"+fieldName +"_share_" + fieldNewPosition).val(tmp_share);
	  //intorder
	  j("#"+fieldName +"_intorder_" + fieldPosition).val(tmp_prev_intorder);
	  j("#"+fieldName +"_intorder_" + fieldNewPosition).val(tmp_intorder);
}