DEDUP_ORDER = [ MYDSPACE_COL_METADATA, MYDSPACE_COL_METADATA+1, MYDSPACE_COL_METADATA+2, 
                MYDSPACE_COL_COMNAME, MYDSPACE_COL_COLNAME, MYDSPACE_COL_HDL, MYDSPACE_COL_STATUS, MYDSPACE_COL_LMOD, MYDSPACE_COL_METADATA+3,
                // invisible columns
                MYDSPACE_COL_PPCOMNAME, MYDSPACE_COL_PPCOMHDL, MYDSPACE_COL_PPCOMID, 
                MYDSPACE_COL_PCOMNAME, MYDSPACE_COL_PCOMHDL, MYDSPACE_COL_PCOMID,
                MYDSPACE_COL_COMHDL, MYDSPACE_COL_COMID,
                MYDSPACE_COL_COLHDL, MYDSPACE_COL_COLID,
                MYDSPACE_COL_SUBEMAIL, MYDSPACE_COL_SUBFN, MYDSPACE_COL_SUBID, MYDSPACE_COL_SUBNETID,MYDSPACE_COL_SUBLN,
                MYDSPACE_COL_OWEMAIL, MYDSPACE_COL_OWFN, MYDSPACE_COL_OWID, MYDSPACE_COL_OWNETID,MYDSPACE_COL_OWLN,
                MYDSPACE_COL_ITEMID, MYDSPACE_COL_WID, 
                MYDSPACE_COL_STATE
                ];

DEDUP_VIS = { "bVisible": false,  "aTargets": [ MYDSPACE_COL_PPCOMNAME, MYDSPACE_COL_PPCOMHDL, MYDSPACE_COL_PPCOMID, 
                                                         MYDSPACE_COL_PCOMNAME, MYDSPACE_COL_PCOMHDL, MYDSPACE_COL_PCOMID,
					                                     MYDSPACE_COL_COMHDL, MYDSPACE_COL_COMID,
					                                     MYDSPACE_COL_COLHDL, MYDSPACE_COL_COLID,
					                                     MYDSPACE_COL_SUBEMAIL, MYDSPACE_COL_SUBFN, MYDSPACE_COL_SUBID, MYDSPACE_COL_SUBNETID,MYDSPACE_COL_SUBLN,
					                                     MYDSPACE_COL_OWEMAIL, MYDSPACE_COL_OWFN, MYDSPACE_COL_OWID, MYDSPACE_COL_OWNETID,MYDSPACE_COL_OWLN,
					                                     MYDSPACE_COL_ITEMID, MYDSPACE_COL_WID, 
					                                     MYDSPACE_COL_STATE, MYDSPACE_COL_STATUS, MYDSPACE_COL_HDL, MYDSPACE_COL_LMOD, MYDSPACE_COL_METADATA+3
					                                    ] };
detailsEvent = "click";
formatDetailsDuplicate = function fnFormatDuplicateDetails ( dataTableObj, settings, nTr, itemID)
{
	var aData = dataTableObj.fnGetData( nTr );
	var idtable = dataTableObj[0].id;
	var sOut = '<div style="position: relative; width: 100%;" class="ui-dialog ui-widget-content ui-dialog">';
	//sOut += '<div class="ui-dialog-titlebar ui-widget-header ui-corner-all ui-helper-clearfix">';
	//sOut += '<span class="ui-dialog-title" id="ui-dialog-title-dialog">Gestisci il record</span><a class="ui-dialog-titlebar-close ui-corner-all" href="#" role="button">';
	//sOut += '<span class="ui-icon ui-icon-closethick">close</span></a></div>';

	var itemid = ''+aData[fnGetColumnIndexBysName(settings, "MYDSPACE_COL_ITEMID")];

	sOut += '<div class="ui-dialog-content ui-widget-content">';
	sOut += '<table>';
	sOut += '<tr><td>Status:</td><td align="left">';
	sOut += aData[fnGetColumnIndexBysName(settings, "MYDSPACE_COL_STATUS")];
	sOut += '</td></tr>';
	sOut += '<tr><td>Handle:</td><td align="left">';
	sOut += aData[fnGetColumnIndexBysName(settings, "MYDSPACE_COL_HDL")];
	sOut += '</td></tr>';
	sOut += '<tr><td>Ultima modifica:</td><td align="left">';
	sOut += aData[fnGetColumnIndexBysName(settings, "MYDSPACE_COL_LMOD")];
	sOut += '</td></tr>';
	
	sOut += '</td></tr></table>';
	sOut += '</div><div class="ui-dialog-buttonpane ui-widget-content ui-helper-clearfix"><div class="ui-dialog-buttonset">';
	sOut += '<button class="ignore">'+SUROA_I18N_DEDUP_IGNORE_BUTTON+'</button><button class="fake">'+SUROA_I18N_DEDUP_FAKE_BUTTON+'</button>';
	sOut += '</div></div>';
	sOut += '</div>';
	return sOut;
}

detailsDuplicateItem = function(detailsEvent, dataTableObj, itemID){
	j('tbody tr',dataTableObj).live(detailsEvent,function () {
		if (!(j(this).hasClass('odd') || j(this).hasClass('even')))
		{
			return;
		}
		
		var settings = dataTableObj.fnSettings();
		var nTr = this;
		var out = formatDetailsDuplicate( dataTableObj, settings, nTr, itemID);
		if (out == null)
			return;
		
		if (settings.currOpenRow != undefined)
		{
			dataTableObj.fnClose(dataTableObj.fnGetNodes(settings.currOpenRow));
			j(dataTableObj.fnGetNodes(settings.currOpenRow)).removeClass("ui-state-highlight");
		}
		settings.currOpenRow = dataTableObj.fnGetPosition(nTr);
		dataTableObj.fnOpen( nTr, out, 'actions' );
		j('tbody tr td.actions button',dataTableObj).button();
		var aData = dataTableObj.fnGetData( nTr );
		j('tbody tr td.actions button.ignore',dataTableObj).click({iid: itemID, did: aData[fnGetColumnIndexBysName(settings, "MYDSPACE_COL_ITEMID")]}, ignoreDupEvent);
		j('tbody tr td.actions button.fake',dataTableObj).click({iid: itemID, did: aData[fnGetColumnIndexBysName(settings, "MYDSPACE_COL_ITEMID")]}, rejectFakeDupEvent);		
		j(nTr).addClass("ui-state-highlight");
	
	});
}

function rejectFakeDup(iid, did)
{
	j.ajax({
		url:"dedup/reject", 
		cache: false,
		data: ({
			itemID: iid,
			duplicateID: did,
			fake: true
			})
		});
}

function ignoreDup(iid, did, note)
{
	j.ajax({
		url:"dedup/reject", 
		cache: false,
		data: ({
			note: note, 
			itemID: iid, 
			duplicateID: did
			})
		});
}

function ignoreDupEvent(event)
{
	j("#duplicateboxignoremsg").data({iid: event.data.iid, did: event.data.did});
	j("#duplicateboxignoremsg").dialog("open");
}	

function rejectFakeDupEvent(event)
{
	rejectFakeDup(event.data.iid, event.data.did);
	var dataTableObj = j("#duplicateboxtable").dataTable();
	var settings = dataTableObj.fnSettings();
	if (settings.currOpenRow != undefined)
	{
		dataTableObj.fnClose(dataTableObj.fnGetNodes(settings.currOpenRow));
	}
	dataTableObj.fnDeleteRow(settings.currOpenRow);
	if (settings.fnRecordsTotal() == 0)
	{
		j("#duplicatebox").dialog("close");
	}
}

function checkDuplicates(itemID)
{
	j.ajax({url: "json/duplicate", 
		dataType: "json", 
		contentType: "application/x-www-form-urlencoded;charset=UTF-8",
		cache: false,
		data: ({itemid: itemID}), 
		success: function(duplicates) {
			if (duplicates.size() > 0 && duplicates.size() < 10)
			{
				var row = j("#duplicatebox").find("table tbody tr:last");
				for (var i = 1; i < duplicates.size(); i++)
				{
					row.clone().insertAfter(row);
				}
				
				var rows =  j("#duplicatebox").find("table tbody tr");
				var tableid = "duplicateboxtable";
				mydspaceData[tableid] = new Object();
				for (var i = 0; i < duplicates.size(); i++)
				{
                    mydspaceData[tableid][''+duplicates[i].duplicateItem['id']] = duplicates[i].duplicateItem;
					var flatdata = itemDTOtoFlatArray(duplicates[i].duplicateItem);
					for (var col = 0; col < flatdata.size(); col++)
					{
						j(j(rows[i]).find("td")[col]).html(flatdata[col]);
					}
					j(j(rows[i]).find("td:last")).children("button.ignore").click({iid: itemID, did: duplicates[i].duplicateItem.id}, ignoreDupEvent);
					j(j(rows[i]).find("td:last")).children("button.fake").click({iid: itemID, did: duplicates[i].duplicateItem.id}, rejectFakeDupEvent);
				}
				j("button","#duplicatebox").button();
				var dupTable = j("#"+tableid).dataTable({
					"sDom": 'R<"H"<i>>t<"F"<i>>',
					"bAutoWidth" : false,
					"bJQueryUI": true,
					"bPaginate": false,
					"bLengthChange": false,
					"bFilter": false,
					"bSort": false,
					"bInfo": true,
					"oColReorder": {
						"aiOrder": DEDUP_ORDER
					},
					"aoColumns": MYDSPACE_COL_ALIAS.concat([{"sName":"actions"}]),
					"aoColumnDefs": myColumnDefs.concat(DEDUP_VIS)} );
				detailsDuplicateItem(detailsEvent, dupTable, itemID);
				j("input:button","#duplicatebox").button();				
				j("#duplicatebox").dialog({modal: true, width: 800, title: SUROA_I18N_DEDUP_DIALOG_TITLE});
				j(rows[0]).click();				
			}
		}
	});
}