mydspaceData = new Object();
MYDSPACE_MYSUBS_ORDER = [ MYDSPACE_COL_METADATA, MYDSPACE_COL_METADATA+1, MYDSPACE_COL_METADATA+2, 
  MYDSPACE_COL_COMNAME, MYDSPACE_COL_COLNAME, MYDSPACE_COL_HDL, MYDSPACE_COL_STATUS, MYDSPACE_COL_LMOD,
  // invisible columns
  MYDSPACE_COL_PPCOMNAME, MYDSPACE_COL_PPCOMHDL, MYDSPACE_COL_PPCOMID, 
  MYDSPACE_COL_PCOMNAME, MYDSPACE_COL_PCOMHDL, MYDSPACE_COL_PCOMID,
  MYDSPACE_COL_COMHDL, MYDSPACE_COL_COMID,
  MYDSPACE_COL_COLHDL, MYDSPACE_COL_COLID,
  MYDSPACE_COL_SUBEMAIL, MYDSPACE_COL_SUBFN, MYDSPACE_COL_SUBID, MYDSPACE_COL_SUBNETID,MYDSPACE_COL_SUBLN,
  MYDSPACE_COL_OWEMAIL, MYDSPACE_COL_OWFN, MYDSPACE_COL_OWID, MYDSPACE_COL_OWNETID,MYDSPACE_COL_OWLN,
  MYDSPACE_COL_ITEMID, MYDSPACE_COL_WID, 
  MYDSPACE_COL_STATE,
  MYDSPACE_COL_METADATA+3 //actions
  ];

MYDSPACE_MYTASKS_ORDER = [ MYDSPACE_COL_METADATA, MYDSPACE_COL_METADATA+1, MYDSPACE_COL_METADATA+2, 
    MYDSPACE_COL_COMNAME, MYDSPACE_COL_COLNAME, MYDSPACE_COL_STATE, MYDSPACE_COL_LMOD,
    // invisible columns
    MYDSPACE_COL_PPCOMNAME, MYDSPACE_COL_PPCOMHDL, MYDSPACE_COL_PPCOMID, 
    MYDSPACE_COL_PCOMNAME, MYDSPACE_COL_PCOMHDL, MYDSPACE_COL_PCOMID,
    MYDSPACE_COL_COMHDL, MYDSPACE_COL_COMID,
    MYDSPACE_COL_COLHDL, MYDSPACE_COL_COLID,
    MYDSPACE_COL_SUBEMAIL, MYDSPACE_COL_SUBFN, MYDSPACE_COL_SUBID, MYDSPACE_COL_SUBNETID,MYDSPACE_COL_SUBLN, 
    MYDSPACE_COL_OWEMAIL, MYDSPACE_COL_OWFN, MYDSPACE_COL_OWID, MYDSPACE_COL_OWNETID,MYDSPACE_COL_OWLN, 
    MYDSPACE_COL_ITEMID, MYDSPACE_COL_WID, 
    MYDSPACE_COL_HDL, MYDSPACE_COL_STATUS,
    MYDSPACE_COL_METADATA+3 //actions
    ];

MYDSPACE_ATASKS_ORDER = [ MYDSPACE_COL_METADATA, MYDSPACE_COL_METADATA+1, MYDSPACE_COL_METADATA+2, 
    MYDSPACE_COL_COMNAME, MYDSPACE_COL_COLNAME, MYDSPACE_COL_STATE, MYDSPACE_COL_LMOD,
    // invisible columns
    MYDSPACE_COL_PPCOMNAME, MYDSPACE_COL_PPCOMHDL, MYDSPACE_COL_PPCOMID, 
    MYDSPACE_COL_PCOMNAME, MYDSPACE_COL_PCOMHDL, MYDSPACE_COL_PCOMID,
   MYDSPACE_COL_COMHDL, MYDSPACE_COL_COMID,
   MYDSPACE_COL_COLHDL, MYDSPACE_COL_COLID,
   MYDSPACE_COL_SUBEMAIL, MYDSPACE_COL_SUBFN, MYDSPACE_COL_SUBID, MYDSPACE_COL_SUBNETID,MYDSPACE_COL_SUBLN, 
   MYDSPACE_COL_OWEMAIL, MYDSPACE_COL_OWFN, MYDSPACE_COL_OWID, MYDSPACE_COL_OWNETID,MYDSPACE_COL_OWLN, 
   MYDSPACE_COL_ITEMID, MYDSPACE_COL_WID, 
   MYDSPACE_COL_HDL, MYDSPACE_COL_STATUS,
   MYDSPACE_COL_METADATA+3 //actions 
   ];

var initMySub = false;
var initMyTasks = false;
var initAvTasks = false;
var initPending = false;
var initPotential = false;
var myPendingObj = null;
var myPotentialObj = null;
var mySubmissionsObj = null;
var myTasksObj = null;
var availableTasksObj = null;

var myExportOption = [
			 			{
			 				"sExtends": "copy",
			 				"mColumns": 'visible'
			 			},
			 			{
			 				"sExtends": "xls",
			 				"mColumns": 'visible'
			 			},
			 			{
			 				"sExtends": "csv",
			 				"mColumns": 'visible'
			 			},
			 			{
			 				"sExtends": "print",
			 				"mColumns": 'visible'
			 			},
			 			{
			 				"sExtends": "pdf",
			 				"sPdfOrientation": 'landscape', 
			 				"mColumns": 'visible'
			 			}
			 		];


fnServerObjectToArray = function (tableid)
{
    return function ( sSource, aoData, fnCallback ) {
        j("#"+tableid+" tbody tr td").hide();
    	j.ajax( {
            "dataType": 'json',
            "type": "POST",
            "url": sSource,
            "data": aoData,
            "error": function(data){
            	if (!mydspaceData.error)
            	{
            		mydspaceData.error = true;
            		alert(SUROA_I18N_MYDSPACE_LOADERROR);
            	}
            },
            "success": function (json) {
            	if (json == null || json.error)
            	{
            		if (!mydspaceData.error)
                	{
            			mydspaceData.error = true;
            			alert(SUROA_I18N_MYDSPACE_LOADERROR);
                	}		
            		json = new Object();
            		json.aaData = [];
	                fnCallback(json);
            		return;
            	}
            	mydspaceData[tableid] = new Object();
               var a = [];
               
                for ( var i=0, iLen=json.data.length ; i<iLen ; i++ ) {
                    mydspaceData[tableid][''+json.data[i]['id']] = json.data[i];
                    var inner = itemDTOtoFlatArray(json.data[i]);
                    a.push( inner );
                }
                json.aaData = a;
                json.iTotalDisplayRecords = json.totalFiltered;
                json.iTotalRecords = json.total;
                json.sEcho = json.reqCount;
                json.sColumns = MYDSPACE_COL_ALIAS[0].sName;
                for (var i=1, sLen=MYDSPACE_COL_ALIAS.length; i < sLen; i++)
				{					
					json.sColumns += ","+MYDSPACE_COL_ALIAS[i].sName;
				}
                fnCallback(json);
            }
        } );
    }
}
detailsEvent = 'click';
detailsMyDSpace = function(detailsEvent, epersonID, dataTableObj){
	j('tbody tr',dataTableObj).live(detailsEvent,function () {
		if (!(j(this).hasClass('odd') || j(this).hasClass('even')))
		{
			return;
		}
		
		var settings = dataTableObj.fnSettings();
		var nTr = this;
		var out = myDSpaceFormatDetails( dataTableObj, settings, nTr, epersonID);
		if (out == null)
			return;
		
		if (settings.currOpenRow != undefined)
		{
			dataTableObj.fnClose(dataTableObj.fnGetNodes(settings.currOpenRow));
			j(dataTableObj.fnGetNodes(settings.currOpenRow)).removeClass("ui-state-highlight");
		}
		settings.currOpenRow = dataTableObj.fnGetPosition(nTr);
		dataTableObj.fnOpen( nTr, out, 'actions' );
		j('tbody tr td.actions input:submit',dataTableObj).button();
		j('tbody tr td.actions button',dataTableObj).button();
		j('tbody tr td.actions a button',dataTableObj).click(
				function(e){
					e.preventDefault();
					window.location = j(this).parent().attr('href');	
				});
		j('tbody tr td.actions a[href=#]',dataTableObj).click(
				function(){
				dataTableObj.fnClose(dataTableObj.fnGetNodes(settings.currOpenRow));
				j(dataTableObj.fnGetNodes(settings.currOpenRow)).removeClass("ui-state-highlight");
				return false;}
		);
		j(dataTableObj).mouseleave(function(){
			dataTableObj.fnClose(dataTableObj.fnGetNodes(settings.currOpenRow));
			j(dataTableObj.fnGetNodes(settings.currOpenRow)).removeClass("ui-state-highlight");
			return false;}
		);
		j(nTr).addClass("ui-state-highlight");
		j('input.potential[name="submit_claim"]').click(function(e){
			e.preventDefault();
			var id = j(this).parent().find('input[name="item_id"]').val();
			claimPotential(id);
		});
		j('input.potential[name="submit_unclaim"]').click(function(e){
			e.preventDefault();
			var id = j(this).parent().find('input[name="item_id"]').val();
			unclaimPotential(id);
		});
	
	});
}

claimPotential = function(id)
{
	j.ajax( {
        "dataType": 'json',
        "type": "POST",
        "url": dspaceContextPath+"/json/pmatches/claim",
        "data": {'item_id': id},
        "error": function(data){
        		alert('impossibile eseguire la richiesta');
        		myPotentialObj.fnDraw();
        	
        },
        "success": function (json) {
        	myPotentialObj.fnDraw();
        	if (myPotentialObj.fnSettings().fnRecordsTotal() == 0)
        	{
        		j("#tabs ul li").has('a[href="#tabs-4"]').toggleClass("loading");
        		j("#tabs ul li").not(".loading").first().children().click();
        	}
        	if (myPendingObj.fnSettings().fnRecordsTotal() == 0)
        	{
        		j("#tabs ul li").has('a[href="#tabs-5"]').toggleClass("loading");
        	}
        	myPendingObj.fnDraw();
        }
	});
}

unclaimPotential = function(id)
{
	j.ajax( {
        "dataType": 'json',
        "type": "POST",
        "url": dspaceContextPath+"/json/pmatches/unclaim",
        "data": {'item_id': id},
        "error": function(data){
        		alert('impossibile eseguire la richiesta');
        		myPotentialObj.fnDraw();
        	
        },
        "success": function (json) {
        	myPotentialObj.fnDraw();
        	if (myPotentialObj.fnSettings().fnRecordsTotal() == 0)
        	{
        		j("#tabs ul li").has('a[href="#tabs-4"]').toggleClass("loading");
        		j("#tabs ul li").not(".loading").first().children().click();
        	}
        }
	});
}

myDSpaceFormatDetails = function ( dataTableObj, settings, nTr, epersonID )
{
	var aData = dataTableObj.fnGetData( nTr );
	var idtable = dataTableObj[0].id;
	var sOut = '<div style="position: relative; width: 100%;" class="ui-dialog ui-widget-content ui-dialog">';
	sOut += '<div class="ui-dialog-titlebar ui-widget-header ui-corner-all ui-helper-clearfix">';
	sOut += '<span class="ui-dialog-title" id="ui-dialog-title-dialog">'+SUROA_I18N_MYDSPACE_ACTIONTITLE+'</span><a class="ui-dialog-titlebar-close ui-corner-all" href="#" role="button">';
	sOut += '<span class="ui-icon ui-icon-closethick">close</span></a></div>';
	var itemid = ''+aData[fnGetColumnIndexBysName(settings, "MYDSPACE_COL_ITEMID")];
	var state = mydspaceData[idtable][itemid].status ;
	if (idtable == 'mysubmissions' && state <= 50)
	{				
		sOut += '<div class="ui-dialog-content ui-widget-content"><table><tr><td>'+SUROA_I18N_MYDSPACE_ACTIONRESUME+'</td><td align="left">';
		sOut += '<form action="'+dspaceContextPath+'/mydspace" method="post">';
		sOut += '    <input name="workspace_id" value="'+mydspaceData[idtable][itemid]['wrapperId']+'" type="hidden">';
		sOut += '    <input name="step" value="0" type="hidden">';
		sOut += '    <input name="resume" value="'+mydspaceData[idtable][itemid]['wrapperId']+'" type="hidden">';
		sOut += '    <input name="submit_resume" value="'+SUROA_I18N_MYDSPACE_ACTIONRESUMEBN+'" type="submit">';
		sOut += '</form>';
		sOut += '</td></tr>';

		sOut += '<tr><td>'+SUROA_I18N_MYDSPACE_ACTIONVIEW+'</td><td align="left">';
		sOut += '<form action="'+dspaceContextPath+'/view-workspaceitem" method="post">';
		sOut += '    <input name="workspace_id" value="'+mydspaceData[idtable][itemid]['wrapperId']+'" type="hidden">';
		sOut += '    <input name="submit_view" value="'+SUROA_I18N_MYDSPACE_ACTIONVIEWBN+'" type="submit">';
		sOut += '</form>';
		sOut += '</td></tr>';
		
		sOut += '<tr><td>'+SUROA_I18N_MYDSPACE_ACTIONREMOVE+'</td><td align="left">';
		sOut += '<form action="'+dspaceContextPath+'/mydspace" method="post">';
		sOut += '    <input name="step" value="0" type="hidden">';
		sOut += '    <input name="workspace_id" value="'+mydspaceData[idtable][itemid]['wrapperId']+'" type="hidden">';
		sOut += '    <input name="submit_delete" value="'+SUROA_I18N_MYDSPACE_ACTIONREMOVEBN+'" type="submit">';
		sOut += '</form>';
		sOut += '</td></tr></table>';
	}
	else if (idtable == 'mytasks')
	{
		sOut += '<div class="ui-dialog-content ui-widget-content"><table><tr><td>'+SUROA_I18N_MYDSPACE_ACTIONPERFORM+'</td><td align="left">';
		sOut += '<form action="'+dspaceContextPath+'/mydspace" method="post">';
		sOut += '    <input name="workflow_id" value="'+mydspaceData[idtable][itemid]['wrapperId']+'" type="hidden">';
		sOut += '    <input name="step" value="0" type="hidden">';
		sOut += '    <input name="submit_perform" value="'+SUROA_I18N_MYDSPACE_ACTIONPERFORMBN+'" type="submit">';
		sOut += '</form>';
		sOut += '</td></tr>';

		sOut += '<tr><td>'+SUROA_I18N_MYDSPACE_ACTIONTOPOOL+'</td><td align="left">';
		sOut += '<form action="'+dspaceContextPath+'/mydspace" method="post">';
		sOut += '    <input name="workflow_id" value="'+mydspaceData[idtable][itemid]['wrapperId']+'" type="hidden">';
		sOut += '    <input name="step" value="0" type="hidden">';
		sOut += '    <input name="submit_return" value="'+SUROA_I18N_MYDSPACE_ACTIONTOPOOLBN+'" type="submit">';
		sOut += '</form>';
		sOut += '</td></tr></table>';
	}
	else if (idtable == 'availabletasks')
	{
		sOut += '<div class="ui-dialog-content ui-widget-content"><table><tr><td>'+SUROA_I18N_MYDSPACE_ACTIONACCEPT+'</td><td align="left">';
		sOut += '<form action="'+dspaceContextPath+'/mydspace" method="post">';
		sOut += '    <input name="workflow_id" value="'+mydspaceData[idtable][itemid]['wrapperId']+'" type="hidden">';
		sOut += '    <input name="step" value="0" type="hidden">';
		sOut += '    <input name="submit_claim" value="'+SUROA_I18N_MYDSPACE_ACTIONACCEPTBN+'" type="submit">';
		sOut += '</form>';
		sOut += '</td></tr></table>';
	}
	else if (idtable == 'mypotential')
	{
		sOut += '<div class="ui-dialog-content ui-widget-content"><table><tr><td>'+SUROA_I18N_MYDSPACE_ACTIONCLAIM+'</td><td align="left">';
		sOut += '    <input name="item_id" value="'+itemid+'" type="hidden">';
		sOut += '    <input class="potential" name="submit_claim" value="'+SUROA_I18N_MYDSPACE_ACTIONCLAIMBN+'" type="submit">';
		sOut += '    <input class="potential" name="submit_unclaim" value="'+SUROA_I18N_MYDSPACE_ACTIONUNCLAIMBN+'" type="submit">';
		sOut += '</td></tr></table>';
	}
	else
	{
		return null;
	}
	sOut += '</div></div>';
	return sOut;
}

enableMyDSpaceTabs = function()
{
	j("#tabs ul li").toggleClass("loading");
	if (myTasksObj.fnSettings().fnRecordsTotal() == 0)
	{
		j("#tabs ul li").has('a[href="#tabs-2"]').addClass("loading");
	}
	if (availableTasksObj.fnSettings().fnRecordsTotal() == 0)
	{
		j("#tabs ul li").has('a[href="#tabs-3"]').addClass("loading");
	}
	if (myPotentialObj.fnSettings().fnRecordsTotal() == 0)
	{
		j("#tabs ul li").has('a[href="#tabs-4"]').addClass("loading");
	}
	if (myPendingObj.fnSettings().fnRecordsTotal() == 0)
	{
		j("#tabs ul li").has('a[href="#tabs-5"]').addClass("loading");
	}
	j("#tabs ul li").not(".loading").first().children().click();
}

fnDraCallback = function(){}
mySubmissionsSort = [ MYDSPACE_COL_LMOD, "desc" ];
myTasksSort = [ MYDSPACE_COL_LMOD, "asc" ];
availableTasksSort =[ MYDSPACE_COL_LMOD, "asc" ];

initializeMyDSpace = function(currUser){
	j(document).ready(function() {
		j("#tabs").tabs( {
			"show": function(event, ui) {
				var dtable = j('table.display', ui.panel);
				for (idx = 0; idx < dtable.length; idx++)
				{
					var tt = TableTools.fnGetInstance(dtable[idx]); 
					if (tt.fnResizeRequired() )
					{
						tt.fnResizeButtons();
					}
				}
				j("input:submit").not(".search").button();
				j("input:button").button();
			}
		});
		
		mySubmissionsObj = j('#mysubmissions').dataTable( {
			"aaSorting": [mySubmissionsSort],
			"fnDrawCallback": function() {fnDraCallback();},
			"oLanguage": dataTableI18N,
			"sDom": 'R<"H"<T><"clear">lfr>t<"F"<"clear">ip>',
			"oTableTools": {
				"sSwfPath": dspaceContextPath+"/swf/copy_cvs_xls_pdf.swf",
				"aButtons": myExportOption
			},
			"fnInitComplete": function () {
				initMySub = true;
				if (initMyTasks && initAvTasks && initPending && initPotential)
				{
					enableMyDSpaceTabs();
				}
			},
			"bAutoWidth" : false,
			"bJQueryUI": true,
			"aLengthMenu": [[5, 10, 25, 50, -1], [5, 10, 25, 50, "All"]],
			"oColReorder": {
				"aiOrder": MYDSPACE_MYSUBS_ORDER
			},
			"bProcessing": true,
			"sPaginationType": "full_numbers",
			"bServerSide": true,
			"sAjaxSource": dspaceContextPath+"/json/mydspace/mysubmissions",
			"fnServerData": fnServerObjectToArray("mysubmissions"),
			"aoColumns": MYDSPACE_COL_ALIAS.concat([{"sName":"actions"}]),
			"aoColumnDefs": mySubColumnDefs
		} );
	
		myPendingObj = j('#mypending').dataTable( {
			"aaSorting": [mySubmissionsSort],
			"fnDrawCallback": function() {fnDraCallback();},
			"oLanguage": dataTableI18N,
			"sDom": 'R<"H"<T><"clear">lfr>t<"F"<"clear">ip>',
			"oTableTools": {
				"sSwfPath": dspaceContextPath+"/swf/copy_cvs_xls_pdf.swf",
				"aButtons": myExportOption
			},
			"fnInitComplete": function () {
				initPending = true;
				if (initMyTasks && initAvTasks && initMySub && initPotential)
				{
					enableMyDSpaceTabs();
				}
			},
			"bAutoWidth" : false,
			"bJQueryUI": true,
			"aLengthMenu": [[5, 10, 25, 50, -1], [5, 10, 25, 50, "All"]],
			"oColReorder": {
				"aiOrder": MYDSPACE_MYSUBS_ORDER
			},
			"bProcessing": true,
			"sPaginationType": "full_numbers",
			"bServerSide": true,
			"sAjaxSource": dspaceContextPath+"/json/mydspace/pending",
			"fnServerData": fnServerObjectToArray("mypending"),
			"aoColumns": MYDSPACE_COL_ALIAS.concat([{"sName":"actions"}]),
			"aoColumnDefs": mySubColumnDefs
		} );
		
		myPotentialObj = j('#mypotential').dataTable( {
			"aaSorting": [mySubmissionsSort],
			"fnDrawCallback": function() {fnDraCallback();},
			"oLanguage": dataTableI18N,
			"sDom": 'R<"H"<T><"clear">lfr>t<"F"<"clear">ip>',
			"oTableTools": {
				"sSwfPath": dspaceContextPath+"/swf/copy_cvs_xls_pdf.swf",
				"aButtons": myExportOption
			},
			"fnInitComplete": function () {
				initPotential = true;
				if (initMyTasks && initAvTasks && initPending && initMySub)
				{
					enableMyDSpaceTabs();
				}
			},
			"bAutoWidth" : false,
			"bJQueryUI": true,
			"aLengthMenu": [[5, 10, 25, 50, -1], [5, 10, 25, 50, "All"]],
			"oColReorder": {
				"aiOrder": MYDSPACE_MYSUBS_ORDER
			},
			"bProcessing": true,
			"sPaginationType": "full_numbers",
			"bServerSide": true,
			"sAjaxSource": dspaceContextPath+"/json/mydspace/potential",
			"fnServerData": fnServerObjectToArray("mypotential"),
			"aoColumns": MYDSPACE_COL_ALIAS.concat([{"sName":"actions"}]),
			"aoColumnDefs": mySubColumnDefs
		} );
		
	myTasksObj = j('#mytasks').dataTable( {
			"aaSorting": [myTasksSort], 
			"oLanguage": dataTableI18N,
			"sDom": 'R<"H"<T><"clear">lfr>t<"F"<"clear">ip>',
			"oTableTools": {
				"sSwfPath": dspaceContextPath+"/swf/copy_cvs_xls_pdf.swf",
				"aButtons": myExportOption},
			"fnInitComplete": function () {
				initMyTasks = true;
				if (initMySub && initAvTasks && initPending && initPotential)
				{
					enableMyDSpaceTabs();
				}
			},
			"bAutoWidth" : false,
			"bJQueryUI": true,
			"aLengthMenu": [[5, 10, 25, 50, -1], [5, 10, 25, 50, "All"]],
			"oColReorder": {
				"aiOrder": MYDSPACE_MYTASKS_ORDER
			},
			"bProcessing": true,
			"sPaginationType": "full_numbers",
			"bServerSide": true,
			"sAjaxSource": dspaceContextPath+"/json/mydspace/mytasks",
			"fnServerData": fnServerObjectToArray("mytasks"),
			"aoColumns": MYDSPACE_COL_ALIAS.concat([{"sName":"actions"}]),
			"aoColumnDefs": myTasksColumnDefs
		} );
		
		availableTasksObj = j('#availabletasks').dataTable( {
			"aaSorting": [availableTasksSort],
			"oLanguage": dataTableI18N,
			"sDom": 'R<"H"<T><"clear">lfr>t<"F"<"clear">ip>',
			"oTableTools": {
				"sSwfPath": dspaceContextPath+"/swf/copy_cvs_xls_pdf.swf",
				"aButtons": myExportOption},
			"fnInitComplete": function () {
				initAvTasks = true;
				if (initMySub && initMyTasks && initPending && initPotential)
				{
					enableMyDSpaceTabs();
				}
			},
			"bAutoWidth" : false,
			"bJQueryUI": true,
			"aLengthMenu": [[5, 10, 25, 50, -1], [5, 10, 25, 50, "All"]],
			"oColReorder": {
				"aiOrder": MYDSPACE_ATASKS_ORDER
			},
			"bProcessing": true,
			"sPaginationType": "full_numbers",
			"bServerSide": true,
			"sAjaxSource": dspaceContextPath+"/json/mydspace/atasks",
			"fnServerData": fnServerObjectToArray("availabletasks"),
			"aoColumns": MYDSPACE_COL_ALIAS.concat([{"sName":"actions"}]),
			"aoColumnDefs": myTasksColumnDefs
		} );
		
		detailsMyDSpace(detailsEvent, currUser, mySubmissionsObj);
		detailsMyDSpace(detailsEvent, currUser, myPendingObj);
		detailsMyDSpace(detailsEvent, currUser, myPotentialObj);
		detailsMyDSpace(detailsEvent, currUser, myTasksObj);
		detailsMyDSpace(detailsEvent, currUser, availableTasksObj);
	} );
}