MYDSPACE_COL_ITEMID = 0;
MYDSPACE_COL_WID = 1;
MYDSPACE_COL_PPCOMNAME = 2;
MYDSPACE_COL_PPCOMID = 3;
MYDSPACE_COL_PPCOMHDL = 4;
MYDSPACE_COL_PCOMNAME = 5;
MYDSPACE_COL_PCOMID = 6;
MYDSPACE_COL_PCOMHDL = 7;
MYDSPACE_COL_COMNAME = 8;
MYDSPACE_COL_COMID = 9;
MYDSPACE_COL_COMHDL = 10;
MYDSPACE_COL_COLNAME = 11;
MYDSPACE_COL_COLID= 12;
MYDSPACE_COL_COLHDL = 13;
MYDSPACE_COL_SUBFN = 14;
MYDSPACE_COL_SUBLN = 15;
MYDSPACE_COL_SUBEMAIL = 16;
MYDSPACE_COL_SUBID = 17;
MYDSPACE_COL_SUBNETID = 18;
MYDSPACE_COL_STATUS = 19;
MYDSPACE_COL_HDL = 20;
MYDSPACE_COL_STATE = 21;
MYDSPACE_COL_LMOD = 22;
MYDSPACE_COL_OWFN = 23;
MYDSPACE_COL_OWLN = 24;
MYDSPACE_COL_OWEMAIL = 25;
MYDSPACE_COL_OWID = 26;
MYDSPACE_COL_OWNETID = 27;
MYDSPACE_COL_METADATA = 28;

MYDSPACE_COL_ALIAS = [
                    { "sName": "MYDSPACE_COL_ITEMID" },
            		{ "sName": "MYDSPACE_COL_WID" },
          			{ "sName": "MYDSPACE_COL_PPCOMNAME" },
          			{ "sName": "MYDSPACE_COL_PPCOMID" },
          			{ "sName": "MYDSPACE_COL_PPCOMHDL" },
          			{ "sName": "MYDSPACE_COL_PCOMNAME" },
          			{ "sName": "MYDSPACE_COL_PCOMID" },
          			{ "sName": "MYDSPACE_COL_PCOMHDL" },
          			{ "sName": "MYDSPACE_COL_COMNAME" },
          			{ "sName": "MYDSPACE_COL_COMID" },
          			{ "sName": "MYDSPACE_COL_COMHDL" },
          			{ "sName": "MYDSPACE_COL_COLNAME" },
          			{ "sName": "MYDSPACE_COL_COLID" },
          			{ "sName": "MYDSPACE_COL_COLHDL" },
          			{ "sName": "MYDSPACE_COL_SUBFN" },
          			{ "sName": "MYDSPACE_COL_SUBLN" },
          			{ "sName": "MYDSPACE_COL_SUBEMAIL" },
          			{ "sName": "MYDSPACE_COL_SUBID" },
          			{ "sName": "MYDSPACE_COL_SUBNETID" },
          			{ "sName": "MYDSPACE_COL_STATUS" },
          			{ "sName": "MYDSPACE_COL_HDL" },
          			{ "sName": "MYDSPACE_COL_STATE" },
          			{ "sName": "MYDSPACE_COL_LMOD" },
          			{ "sName": "MYDSPACE_COL_OWFN" },
          			{ "sName": "MYDSPACE_COL_OWLN" },
          			{ "sName": "MYDSPACE_COL_OWEMAIL" },
          			{ "sName": "MYDSPACE_COL_OWID" },
          			{ "sName": "MYDSPACE_COL_OWNETID" },
          			{ "sName": "MYDSPACE_COL_METADATA" }];

myColumnDefs = [ 
				{
					"fnRender": function ( oObj ) {
						var dataTableObj = oObj.oSettings.oInstance;
	                    var idtable = dataTableObj[0].id;
	                    var itemid = ''+oObj.aData[fnGetColumnIndexBysName(oObj.oSettings, "MYDSPACE_COL_ITEMID")];
	                    var text = mydspaceData[idtable][itemid].ppcommunity.handle;
	                    var display = mydspaceData[idtable][itemid].ppcommunity.name;
						if (text  == "" || text  == null)
							return 'N/A';
						return '<a href="'+dspaceContextPath+'/handle/'+text+'">'+display+'</a>';						
					},
					"aTargets": [MYDSPACE_COL_PPCOMNAME ]
				},
				{
					"fnRender": function ( oObj ) {
						var dataTableObj = oObj.oSettings.oInstance;
	                    var idtable = dataTableObj[0].id;
	                    var itemid = ''+oObj.aData[fnGetColumnIndexBysName(oObj.oSettings, "MYDSPACE_COL_ITEMID")];
	                    var text = mydspaceData[idtable][itemid].pcommunity.handle;
	                    var display = mydspaceData[idtable][itemid].pcommunity.name;
						if (text  == "" || text  == null)
							return 'N/A';
						return '<a href="'+dspaceContextPath+'/handle/'+text+'">'+display+'</a>';
					},
					"aTargets": [MYDSPACE_COL_PCOMNAME ]
				},
				{
					"fnRender": function ( oObj ) {
						var dataTableObj = oObj.oSettings.oInstance;
	                    var idtable = dataTableObj[0].id;
	                    var itemid = ''+oObj.aData[fnGetColumnIndexBysName(oObj.oSettings, "MYDSPACE_COL_ITEMID")];
	                    var text = mydspaceData[idtable][itemid].community.handle;
	                    var display = mydspaceData[idtable][itemid].community.name;
						if (text  == "" || text  == null)
							return 'N/A';
						return '<a href="'+dspaceContextPath+'/handle/'+text+'">'+display+'</a>';
					},
					"aTargets": [MYDSPACE_COL_COMNAME ]
				},
				{
					"fnRender": function ( oObj ) {
						var dataTableObj = oObj.oSettings.oInstance;
	                    var idtable = dataTableObj[0].id;
	                    var itemid = ''+oObj.aData[fnGetColumnIndexBysName(oObj.oSettings, "MYDSPACE_COL_ITEMID")];
	                    var text = mydspaceData[idtable][itemid].collection.handle;
	                    var display = mydspaceData[idtable][itemid].collection.name;
						if (text  == "" || text  == null)
							return 'N/A';
						return '<a href="'+dspaceContextPath+'/handle/'+text+'">'+display+'</a>';
					},
					"aTargets": [MYDSPACE_COL_COLNAME ]
				},
				{
					"fnRender": function ( oObj ) {
							var dataTableObj = oObj.oSettings.oInstance;
		                    var idtable = dataTableObj[0].id;
		                    var itemid = ''+oObj.aData[fnGetColumnIndexBysName(oObj.oSettings, "MYDSPACE_COL_ITEMID")];
//		                    var text = mydspaceData[idtable][itemid].submitter.email;
		                    var firstname = mydspaceData[idtable][itemid].submitter.firstName;
		                    var lastname = mydspaceData[idtable][itemid].submitter.lastName;
		                    var display = firstname+' '+lastname;
							if (display  == "" || display  == null)
								return 'N/A';
							return display;
					},
					"aTargets": [MYDSPACE_COL_SUBLN]
				},
				{
					"fnRender": function ( oObj ) {
						var itemid = ''+oObj.aData[fnGetColumnIndexBysName(oObj.oSettings, "MYDSPACE_COL_ITEMID")];
						var idtable = oObj.oSettings.sTableId;
						var own = null;
						try {
							own = mydspaceData[idtable][itemid].owner;
						}
						catch(exception) {
							own = oObj.aData[fnGetColumnIndexBysName(oObj.oSettings, "MYDSPACE_COL_OWID")];
						} 
						if (own == -1)
							return 'N/A';
						return '<a href="mailto:'+oObj.aData[fnGetColumnIndexBysName(oObj.oSettings, "MYDSPACE_COL_OWEMAIL")] +'">'+ oObj.aData[fnGetColumnIndexBysName(oObj.oSettings, "MYDSPACE_COL_OWLN")]+', '+ oObj.aData[fnGetColumnIndexBysName(oObj.oSettings, "MYDSPACE_COL_OWFN")]+'</a>';
					},
					"aTargets": [MYDSPACE_COL_OWLN]
				},
				{
					"fnRender": function ( oObj ) {
						var dataTableObj = oObj.oSettings.oInstance;
	                    var idtable = dataTableObj[0].id;
	                    var itemid = ''+oObj.aData[fnGetColumnIndexBysName(oObj.oSettings, "MYDSPACE_COL_ITEMID")];
	                    var text = mydspaceData[idtable][itemid].handle;
//	                    var display = mydspaceData[idtable][itemid].submitter.firstname + ' ' + mydspaceData[idtable][itemid].submitter.lastname;
						if (text  == "" || text  == null)
							return 'N/A';
						return '<a href="'+dspaceContextPath+'/handle/'+text+'">'+text+'</a>';
					},
					"aTargets": [MYDSPACE_COL_HDL]
				},
				{
					"fnRender": function ( oObj ) {
						var itemid = ''+oObj.aData[fnGetColumnIndexBysName(oObj.oSettings, "MYDSPACE_COL_ITEMID")];
						var idtable = oObj.oSettings.sTableId;
						var currentTime = null;
						try {
							currentTime = new Date(mydspaceData[idtable][itemid].lastModified);
						}
						catch(exception) {
							currentTime =  new Date(parseInt(oObj.aData[fnGetColumnIndexBysName(oObj.oSettings, "MYDSPACE_COL_LMOD")]));
						}
						var month = currentTime.getMonth() + 1;
						var day = currentTime.getDate();
						var year = currentTime.getFullYear();		
						var hr = currentTime.getHours();
						var min = currentTime.getMinutes(); 
						return (day + "/" + month + "/" + year + " "+(hr<10?"0"+hr:hr)+":"+(min<10?"0"+min:min));
					},
					"aTargets": [MYDSPACE_COL_LMOD]
				},
				{
					"fnRender": function ( oObj ) {
						var itemid = ''+oObj.aData[fnGetColumnIndexBysName(oObj.oSettings, "MYDSPACE_COL_ITEMID")];
						var idtable = oObj.oSettings.sTableId;
						var status = null;
						try {
							status = mydspaceData[idtable][itemid].status;
						}
						catch(exception) {
							status = oObj.aData[fnGetColumnIndexBysName(oObj.oSettings, "MYDSPACE_COL_STATUS")];
						}
						if (status >= 0 && status < 50)
						{
							return '<img src="'+dspaceContextPath+'/image/workspace.png" title="'+SUROA_I18N_MYDSPACE_STATUS_0_50+'" />'+SUROA_I18N_MYDSPACE_STATUS_0_50;
						}
						else if (status >= 50 && status < 100)
						{
							return '<img src="'+dspaceContextPath+'/image/workspace-red.png" title="'+SUROA_I18N_MYDSPACE_STATUS_50_100+'" />'+SUROA_I18N_MYDSPACE_STATUS_50_100;
						}
						else if (status >= 100 && status < 200)
						{
							return '<img src="'+dspaceContextPath+'/image/workflow.png" title="'+SUROA_I18N_MYDSPACE_STATUS_100_200+'" />'+SUROA_I18N_MYDSPACE_STATUS_100_200;
						}
						else if (status == 300)
						{
							return '<img src="'+dspaceContextPath+'/image/update.png" title="'+SUROA_I18N_MYDSPACE_STATUS_UPDATE+'" />'+SUROA_I18N_MYDSPACE_STATUS_UPDATE;
						}
						return '<img src="'+dspaceContextPath+'/image/pubblicato.png" title="'+SUROA_I18N_MYDSPACE_STATUS_COMPLETED+'" />'+SUROA_I18N_MYDSPACE_STATUS_COMPLETED;
					},
					"aTargets": [MYDSPACE_COL_STATUS]
				},
				{
					"fnRender": function ( oObj ) {
						var state = oObj.aData[fnGetColumnIndexBysName(oObj.oSettings, "MYDSPACE_COL_STATE")];
						if (state == 1)
						{
							return SUROA_I18N_MYDSPACE_STATE_POOL1;
						}
						else if (state == 2)
						{
							return SUROA_I18N_MYDSPACE_STATE_STEP1;
						}
						else if (state == 3)
						{
							return SUROA_I18N_MYDSPACE_STATE_POOL2;
						}
						else if (state == 4)
						{
							return SUROA_I18N_MYDSPACE_STATE_STEP2;
						}
						else if (state == 5)
						{
							return SUROA_I18N_MYDSPACE_STATE_POOL3;
						}
						else if (state == 6)
						{
							return SUROA_I18N_MYDSPACE_STATE_STEP3;
						}
						return SUROA_I18N_MYDSPACE_STATE_UNKNOWN;
					},
					"aTargets": [MYDSPACE_COL_STATE]
				}	
			];

fnGetColumnIndexBysName = function ( oSettings, sName ) 
{
var cols = oSettings.aoColumns;
for ( var x=0, xLen=cols.length ; x<xLen ; x++ )
{
	if ( cols[x].sName == sName )
	{
		return x;
	};
}
return -1;
}

function itemDTOtoFlatArray(itemDTO)
{
	inner = [];
	inner.push( itemDTO['id'] );
    inner.push( itemDTO['wrapperId'] );
    if (itemDTO['ppcommunity'] != null)
    {
        inner.push( itemDTO['ppcommunity'].name);
    	inner.push( itemDTO['ppcommunity'].id);
    	inner.push( itemDTO['ppcommunity'].handle);
    }
    else
	{
		inner.push(null);
		inner.push(null);
		inner.push(null);
	}
    
    if (itemDTO['pcommunity'] != null)
    {
    	inner.push( itemDTO['pcommunity'].name);
    	inner.push( itemDTO['pcommunity'].id);
    	inner.push( itemDTO['pcommunity'].handle);
    }
    else
	{
    	inner.push(null);
		inner.push(null);
		inner.push(null);
	}
	
    if (itemDTO['community'] != null)
    {
        inner.push( itemDTO['community'].name);
    	inner.push( itemDTO['community'].id);
    	inner.push( itemDTO['community'].handle);
    }
    else
	{
    	inner.push(null);
		inner.push(null);
		inner.push(null);
	}
    
    if (itemDTO['collection'] != null)
    {
        inner.push( itemDTO['collection'].name );
        inner.push( itemDTO['collection'].id );
        inner.push( itemDTO['collection'].handle );
    }
    else
	{
    	inner.push(null);
		inner.push(null);
		inner.push(null);
	}
    
    if (itemDTO['submitter'] != null)
    {
        inner.push( itemDTO['submitter'].firstName );
        inner.push( itemDTO['submitter'].lastName );
        inner.push( itemDTO['submitter'].email );
        inner.push( itemDTO['submitter'].id );
        inner.push( itemDTO['submitter'].netid );
    }
    else
	{
    	inner.push(null);
		inner.push(null);
		inner.push(null);
		inner.push(null);
		inner.push(null);
	}
    inner.push( itemDTO['status'] );
    inner.push( itemDTO['handle'] );
    inner.push( itemDTO['workflowState'] );
    inner.push( itemDTO['lastModified'] );
    
    if (itemDTO['owner'] != null)
    {
        inner.push( itemDTO['owner'].firstName );
        inner.push( itemDTO['owner'].lastName );
        inner.push( itemDTO['owner'].email );
        inner.push( itemDTO['owner'].id );
        inner.push( itemDTO['owner'].netid );
    }
    else
	{
    	inner.push(null);
		inner.push(null);
		inner.push(null);
		inner.push(null);
		inner.push(null);
	}
    
    for (idx = 0; idx < itemDTO['metadataColumns'].length; idx++)
    {
    	inner.push( itemDTO['metadataColumns'][idx] );
    }
    // placeholder for the action column
    inner.push(null);
    return inner ;	
}

jQuery.fn.dataTableExt.oApi.fnFilterOnReturn = function (oSettings) {
    /*
    * Usage:       $('#example').dataTable().fnFilterOnReturn();
    * Author:      Jon Ranes (www.mvccms.com)
    * License:     GPL v2 or BSD 3 point style
    * Contact:     jranes /AT\ mvccms.com
    */
    var _that = this;
 
    this.each(function (i) {
        j.fn.dataTableExt.iApiIndex = i;
//        var $this = this;
        var anControl = j('input', _that.fnSettings().aanFeatures.f);
        anControl.unbind('keyup').bind('keypress', function (e) {
            if (e.which == 13) {
                j.fn.dataTableExt.iApiIndex = i;
                _that.fnFilter(anControl.val());
            }
        });        
        return this;
    });
    return this;
}

function controlCodes(dc, value, isISBNorISSN) { //true ISBN false ISSN
	var intRegex = /[0-9 -()+]+$/;	
	var control = 0;
	var indexControl = 1;
	var prefix = value.substring(0,3);
	var charControlPrefix = 0;
	if(prefix=='978' || prefix=='979' || prefix=='977') {
		charControlPrefix = 3;
	}
	
	var iovSpecialX = value.indexOf("X");				
	value = value.replace("X","");
	
	if(value.match(intRegex)) {
		if(iovSpecialX>0) {
			value += "X";
		}
		var mod = 0;
		if(isISBNorISSN) {
			if(value.length==10) {
				mod = isISBN10Valid(value);		
			}
			else {
				mod = isISBN13Valid(value);
			}
		}
		else {
			for(i=value.length-1; i>=charControlPrefix;i--) {
				var charat = value.charAt(i);
				if(charat.match(intRegex)) {
					control += charat*indexControl;			
				}
				else {
					if(charat=='X') {
						control += 10;
					}
				}
				indexControl++;
			}
			mod = control%11;		
		}
		if(mod!=0) {
			j( "#isbnissnerror" ).dialog("open");
		}
	}
	else {
		j( "#isbnissnerror" ).dialog("open");
	}
}

function insertHypen4ISSN(value) {
	if(value.length==8) {
	var tmpvalue = "";		
		for(i = 0; i<value.length; i++) {
			if(i==4) {
				tmpvalue += "-" + value[i];
			}
			else {
				tmpvalue += value[i];
			}
		}
		return tmpvalue;
	}
	return value;
}

function customReplaceAll(source,stringToFind,stringToReplace){

  var temp = source;

    var index = temp.indexOf(stringToFind);

        while(index != -1){

            temp = temp.replace(stringToFind,stringToReplace);

            index = temp.indexOf(stringToFind);

        }

        return temp;

}

function isISBN13Valid(isbn) {
    var check = 0;
    for (i = 0; i < 12; i += 2) {
        check += (isbn.substring(i, i + 1));
    }
    for (i = 1; i < 12; i += 2) {
        check += (isbn.substring(i, i + 1)) * 3;
    }
    check += (isbn.substring(12));
    return check % 10 == 0;
}

function isISBN10Valid(isbn) {
    var check = 0;
    var t = isbn.substring(9);
    for (var i = 0; i < 9; i++) {
        check += (isbn.substring(i, i + 1)) * (10 - i);
    }
    check += (t=="x" || t=="X") ? 10 : t;
    return check % 11 == 0 ;
}


