/*
 * utils.js
 *
 * Version: $Revision: 2081 $
 *
 * Date: $Date: 2007-07-20 22:52:58 +0200 (ven, 20 lug 2007) $
 *
 * Copyright (c) 2004, Hewlett-Packard Company and Massachusetts
 * Institute of Technology.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * - Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * - Neither the name of the Hewlett-Packard Company nor the name of the
 * Massachusetts Institute of Technology nor the names of their
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

/*
 * Utility Javascript methods for DSpace
 */

// Popup window - here so it can be referred to by several methods
var popupWindow;

// =========================================================
//  Methods for e-person popup window
// =========================================================

// Add to list of e-people on this page -- invoked by eperson popup window
function addEPerson(id, email, name)
{
    var newplace = window.document.epersongroup.eperson_id.options.length;

    if (newplace > 0 && window.document.epersongroup.eperson_id.options[0].value == "")
    {
        newplace = 0;
    }

    // First we check to see if e-person is already there
    for (var i = 0; i < window.document.epersongroup.eperson_id.options.length; i++)
    {
        if (window.document.epersongroup.eperson_id.options[i].value == id)
        {
            newplace = -1;
        }
    }

    if (newplace > -1)
    {
        window.document.epersongroup.eperson_id.options[newplace] = new Option(name + " (" + email + ")", id);
    }
}

// Add to list of groups on this page -- invoked by eperson popup window
function addGroup(id, name)
{
    var newplace = window.document.epersongroup.group_ids.options.length;

	if (newplace > 0 && window.document.epersongroup.group_ids.options[0].value == "")
    {
        newplace = 0;
    }

    // First we check to see if group is already there
    for (var i = 0; i < window.document.epersongroup.group_ids.options.length; i++)
    {
        // is it in the list already
        if (window.document.epersongroup.group_ids.options[i].value == id)
        {
            newplace = -1;
        }

        // are we trying to add the new group to the new group on an Edit Group page (recursive)
        if (window.document.epersongroup.group_id)
        {
            if (window.document.epersongroup.group_id.value == id)
            {
                newplace = -1;
            }
        }
    }

    if (newplace > -1)
    {
        window.document.epersongroup.group_ids.options[newplace] = new Option(name + " (" + id + ")", id);
    }
}

// This needs to be invoked in the 'onClick' javascript event for buttons
// on pages with a dspace:selecteperson element in them
function finishEPerson()
{
    dspaceSelectAll(window.document.epersongroup.eperson_id);

	if (popupWindow != null)
	{
		popupWindow.close();
	}
}

// This needs to be invoked in the 'onClick' javascript event for buttons
// on pages with a dspace:selecteperson element in them
function finishGroups()
{
    dspaceSelectAll(window.document.epersongroup.group_ids);

    if (popupWindow != null)
    {
		popupWindow.close();
    }
}

// =========================================================
//  Miscellaneous utility methods
// =========================================================

// Open a popup window (or bring to front if already open)
function popup_window(winURL, winName)
{
    var props = 'scrollBars=yes,resizable=yes,toolbar=no,menubar=no,location=no,directories=no,width=640,height=480';
    popupWindow = window.open(winURL, winName, props);
    popupWindow.focus();
}


// Select all options in a <SELECT> list
function dspaceSelectAll(sourceList)
{
    for(var i = 0; i < sourceList.options.length; i++)
    {
        if ((sourceList.options[i] != null) && (sourceList.options[i].value != ""))
            sourceList.options[i].selected = true;
    }
    return true;
}

// Deletes the selected options from supplied <SELECT> list
function removeSelected(sourceList)
{
    var maxCnt = sourceList.options.length;
    for(var i = maxCnt - 1; i >= 0; i--)
    {
        if ((sourceList.options[i] != null) && (sourceList.options[i].selected == true))
        {
            sourceList.options[i] = null;
        }
    }
}


// Disables accidentally submitting a form when the "Enter" key is pressed.
// Just add "onkeydown='return disableEnterKey(event);'" to form.
function disableEnterKey(e)
{
     var key;

     if(window.event)
          key = window.event.keyCode;     //Internet Explorer
     else
          key = e.which;     //Firefox & Netscape

     if(key == 13)  //if "Enter" pressed, then disable!
          return false;
     else
          return true;
}


//******************************************************
// Functions used by controlled vocabulary add-on
// There might be overlaping with existing functions
//******************************************************

function expandCollapse(node, contextPath) {
	node = node.parentNode;
	var childNode  = (node.getElementsByTagName("ul"))[0];

	if(!childNode) return false;

	var image = node.getElementsByTagName("img")[0];
	
	if(childNode.style.display != "block") {
		childNode.style.display  = "block";
		image.src = contextPath + "/image/controlledvocabulary/m.gif";
		image.alt = "Collapse search term category";
	} else {
		childNode.style.display  = "none";
		image.src = contextPath + "/image/controlledvocabulary/p.gif";
		image.alt = "Expand search term category";
	}
	
	return false;
}


function getAnchorText(ahref) {
 	if(isMicrosoft()) return ahref.childNodes.item(0).nodeValue;
	else return ahref.text;
}

function getTextValue(node) {
 	if(node.nodeName == "A") {
 		return getAnchorText(node);
 	} else {
 		return "";
 	}
 	
}


function getParentTextNode(node) {
	var parentNode = node.parentNode.parentNode.parentNode;
	var children = parentNode.childNodes;
	var textNode;
	for(var i=0; i< children.length; i++) {
		var child = children.item(i);
		if(child.className == "value") {
			return child;
		}
	}
	return null;
}

function ec(node, contextPath) {
	expandCollapse(node, contextPath);
	return false;
}


function i(node) {
	return sendBackToParentWindow(node);
}


function getChildrenByTagName(rootNode, tagName) {
	var children = rootNode.childNodes;
	var result = new Array(0);
	if(children == null) return result;
	for(var i=0; i<children.length; i++) {
		if(children[i].tagName == tagName) {
			var elementArray = new Array(1);
			elementArray[0] = children[i];
			result = result.concat(elementArray);
		}
	}
	return result;
}

function popUp(URL) {
	var page;
	page = window.open(URL, 'controlledvocabulary', 'toolbar=0,scrollbars=1,location=0,statusbar=0,menubar=0,resizable=1,width=650,height=450');
}


function isNetscape(v) {
		  return isBrowser("Netscape", v);
}
	
function isMicrosoft(v) {
		  return isBrowser("Microsoft", v);
}

function isMicrosoft() {
		  return isBrowser("Microsoft", 0);
}


function isBrowser(b,v) {
		  browserOk = false;
		  versionOk = false;

		  browserOk = (navigator.appName.indexOf(b) != -1);
		  if (v == 0) versionOk = true;
		  else  versionOk = (v <= parseInt(navigator.appVersion));
		  return browserOk && versionOk;
}

//## SURPLUSOA ADD - Modifica per embargo
function embargoChoose(choose){
    var radioChoose = document.getElementById(choose);

    if(!radioChoose) return false;
    
    var radioEmbargo = document.getElementById('embargo');
    var embargoDate = document.getElementById('embargo_date');
    var embargo_td_date = document.getElementById('embargo_td_date');
    var radioAuthEmbargo = document.getElementById('embargoauth');
    var embargoAuthDate = document.getElementById('embargo_auth_date');
    var radioNeverEmbargo = document.getElementById('never_embargo');
    var radioOnlyUni = document.getElementById('only_uni_embargo');
    var radioNoEmbargo = document.getElementById('no_embargo');
    var radioKeepCurrent = document.getElementById('keepcurrent');
    
    if(radioChoose.value == "embargo"){
    	if (embargo_td_date != null)
    		embargo_td_date.style.visibility = "visible";
    	if (radioAuthEmbargo != null)
        	radioAuthEmbargo.checked = false;
        if (embargoAuthDate != null)
        {
        	embargoAuthDate.value = '';
     	    embargoAuthDate.disabled = true;
        }
       if (radioNeverEmbargo != null)
    	   radioNeverEmbargo.checked = false;
       
       if (radioNoEmbargo != null)
    	   radioNoEmbargo.checked = false;
       
       if (radioOnlyUni != null)
    	   radioOnlyUni.checked = false;
       if (embargoDate != null)
    	   embargoDate.disabled = false;
       if (radioKeepCurrent != null)
    	   radioKeepCurrent.checked = false;
    }else if(radioChoose.value == "embargoauth"){
    	if (embargo_td_date != null)
    		embargo_td_date.style.visibility = "hidden";
        if (radioEmbargo != null)
        	radioEmbargo.checked = false;
        if (embargoDate != null)
        {
        	embargoDate.value = '';
        	embargoDate.disabled = true;
        }
        if (radioNeverEmbargo != null)
     	   radioNeverEmbargo.checked = false;
        
        if (radioNoEmbargo != null)
     	   radioNoEmbargo.checked = false;
        
        if (radioOnlyUni != null)
     	   radioOnlyUni.checked = false;
        if (embargoAuthDate != null)
     	   embargoAuthDate.disabled = false;
        if (radioKeepCurrent != null)
     	   radioKeepCurrent.checked = false;
     }else if(radioChoose.value == "never_embargo"){
    	 if (embargo_td_date != null)
     		embargo_td_date.style.visibility = "hidden";
    	 if (radioAuthEmbargo != null)
         	radioAuthEmbargo.checked = false;
    	 if (embargoAuthDate != null)
         {
         	embargoAuthDate.value = '';
      	    embargoAuthDate.disabled = true;
         }
       if (radioEmbargo != null)
    	   radioEmbargo.checked = false;

       if (radioNoEmbargo != null)
    	   radioNoEmbargo.checked = false;
       
       if (radioOnlyUni != null)
    	   radioOnlyUni.checked = false;
       
       if (embargoDate != null)
       {
       	embargoDate.value = '';
       	embargoDate.disabled = true;
       }
       if (radioKeepCurrent != null)
    	   radioKeepCurrent.checked = false;

    }else if(radioChoose.value == "only_uni_embargo"){
    	if (embargo_td_date != null)
    		embargo_td_date.style.visibility = "hidden";
    	if (radioAuthEmbargo != null)
        	radioAuthEmbargo.checked = false;
    	if (embargoAuthDate != null)
        {
        	embargoAuthDate.value = '';
     	    embargoAuthDate.disabled = true;
        }
       if (radioNeverEmbargo != null)
    	   radioNeverEmbargo.checked = false;

       if (radioEmbargo != null)
    	   radioEmbargo.checked = false;

       if (radioNoEmbargo != null)
    	   radioNoEmbargo.checked = false;
       if (embargoDate != null)
       {
       	embargoDate.value = '';
       	embargoDate.disabled = true;
       }
       if (radioKeepCurrent != null)
    	   radioKeepCurrent.checked = false;

    }else if(radioChoose.value == "no_embargo"){
    	if (embargo_td_date != null)
    		embargo_td_date.style.visibility = "hidden";
    	if (radioAuthEmbargo != null)
        	radioAuthEmbargo.checked = false;
    	if (embargoAuthDate != null)
        {
        	embargoAuthDate.value = '';
     	    embargoAuthDate.disabled = true;
        }
        if (radioNeverEmbargo != null)
     	   radioNeverEmbargo.checked = false;

        if (radioEmbargo != null)
     	   radioEmbargo.checked = false;
        
        if (radioOnlyUni != null)
     	   radioOnlyUni.checked = false;
        if (embargoDate != null)
        {
        	embargoDate.value = '';
        	embargoDate.disabled = true;
        }
        if (radioKeepCurrent != null)
     	   radioKeepCurrent.checked = false;
    }else if(radioChoose.value == "keepcurrent"){
    	if (embargo_td_date != null)
    		embargo_td_date.style.visibility = "hidden";
    	if (embargoAuthDate != null)
        {
        	embargoAuthDate.value = '';
     	    embargoAuthDate.disabled = true;
        }
    	if (radioAuthEmbargo != null)
        	radioAuthEmbargo.checked = false;
        if (radioNeverEmbargo != null)
      	   radioNeverEmbargo.checked = false;

         if (radioEmbargo != null)
      	   radioEmbargo.checked = false;
         
         if (radioOnlyUni != null)
      	   radioOnlyUni.checked = false;
         if (embargoDate != null)
         {
         	embargoDate.value = '';
         	embargoDate.disabled = true;
         }
         if (radioNoEmbargo != null)
      	   radioNoEmbargo.checked = false;
     }
}



function controlFileName(){
	if(document.getElementById('tfile').value != ''){
		if(confirm('Attenzione il file: ' + document.getElementById('tfile').value + ' non verra\' caricato in DocTA. Continuare con l\'operazione?')){
			clearFileInputField('uploadFile_div');
			return true;
		}else{
			return false;
		}
	}
}

function clearFileInputField(tagId) { document.getElementById(tagId).innerHTML = document.getElementById(tagId).innerHTML; }

function submitWithEmbargo(){
    var radioEmbargoChoose = document.getElementById('embargo');
    var radioEmbargoAuthChoose = document.getElementById('embargoauth');
    var radioNeverEmbargo = document.getElementById('never_embargo');
    var radioOnlyUni = document.getElementById('only_uni_embargo');
    var radioNoEmbargo = document.getElementById('no_embargo');

    var radioChecked = (radioEmbargoChoose != null && radioEmbargoChoose.checked) || 
    		(radioNeverEmbargo != null && radioNeverEmbargo.checked) || 
    		(radioNoEmbargo != null && radioNoEmbargo.checked) || 
    		(radioOnlyUni != null && radioOnlyUni.checked) ||
    		(radioEmbargoAuthChoose != null && radioEmbargoAuthChoose.checked);
    
    if(!radioChecked) 
    {
		if(document.getElementById('tfile').value != ''){
			alert('Scegliere almeno un\'opzione di embargo');
			return false;
		}else{
			return true;
		}
    }
	else
	{	
		var datePattern = /^[0-3][0-9]\/[0-1][0-9]\/2[0-9][0-9]{2}$/g;
		if ((radioEmbargoChoose != null && radioEmbargoChoose.checked && document.getElementById('embargo_date').value == '') ||
			(radioEmbargoAuthChoose != null && radioEmbargoAuthChoose.checked && document.getElementById('embargo_auth_date').value == '')	
		) {
			alert('Seleziona una data di fine embargo');
			return false;
		}
		else if ((radioEmbargoChoose != null && radioEmbargoChoose.checked 
					&& !document.getElementById('embargo_date').value.match(datePattern)) 
		) {
			alert('Data di fine embargo non valida inserirla nella forma dd/mm/yyyy');
			return false;
		} 
		else
			return true;
	}
}

function enableEmbargo(clear){
    var radioEmbargoChoose = document.getElementById('embargo');
    var radioEmbargoAuthChoose = document.getElementById('embargoauth');
    var radioNeverEmbargo = document.getElementById('never_embargo');
    var radioOnlyUni = document.getElementById('only_uni_embargo');
    var radioNoEmbargo = document.getElementById('no_embargo');
    var embargoDate = document.getElementById('embargo_date');
    var embargoAuthDate = document.getElementById('embargo_auth_date');
    var chooseSitoDocente = document.getElementById('choose-sito-docente');
    var embargo_td_date = document.getElementById('embargo_td_date');
    
    if(clear == 0){
       if (radioEmbargoChoose != null) 
       {
    	   radioEmbargoChoose.disabled = false;
//    	   embargoDate.disabled = false;
       }
       if (radioEmbargoAuthChoose != null) 
       {
    	   radioEmbargoAuthChoose.disabled = false;
       }
       if (radioNeverEmbargo != null)
    	   radioNeverEmbargo.disabled = false;
       if (radioNoEmbargo != null)
    	   radioNoEmbargo.disabled = false;
       if (radioOnlyUni != null)
    	   radioOnlyUni.disabled = false;
       if (chooseSitoDocente != null)
    	   chooseSitoDocente.disabled = false;
    }else{
    	if (radioEmbargoChoose != null)
    	{    		
    		radioEmbargoChoose.disabled = true;
    		embargoDate.disabled = true;
    		embargo_td_date.style.visibility='hidden';
    	}
    	if (radioEmbargoAuthChoose != null) 
        {
     	   radioEmbargoAuthChoose.disabled = true;
     	   embargoAuthDate.disabled = true;
        }
    	if (radioNeverEmbargo != null)
    		radioNeverEmbargo.disabled = true;
    	if (radioNoEmbargo != null)
    		radioNoEmbargo.disabled = true;
    	if (radioOnlyUni != null)
     	   radioOnlyUni.disabled = true;
    	if (chooseSitoDocente != null)
    		chooseSitoDocente.disabled = true;    	
    }
}

function checkDate(data_iniziale, data_finale) {
	var arr1 = data_iniziale.split("/");
	var arr2 = data_finale.split("/");

	var d1 = new Date(arr1[2],arr1[1]-1,arr1[0]);
	var d2 = new Date(arr2[2],arr2[1]-1,arr2[0]);

	var r1 = d1.getTime();
	var r2 = d2.getTime();

	if (r1<=r2) return false;
	
	return true;
}


function PopupFullscreen(filename) {
	   var w = screen.width;
	   var h = screen.height;
	   var l = 0;
	   var t = 0;
	   	window.open(filename,"","width=" + w + ",height=" + h + ",top=" + t + ",left=" + l + ",scrollbars=1");
	}


function PopupCentrata(filename) {
   var w = 800;
   var h = 600;
   var l = Math.floor((screen.width-w)/2);
   var t = Math.floor((screen.height-h)/2);
   	window.open(filename,"","width=" + w + ",height=" + h + ",top=" + t + ",left=" + l + ",scrollbars=1");
}

function moveHTMLContent(sourceid, targetid){
	var source = document.getElementById(sourceid);
	var target = document.getElementById(targetid);
	target.appendChild(source.parentNode.removeChild(source));
}

function sortBy(idx, ord)
{
	jQuery('#sort_by').val(idx);
	jQuery('#order').val(ord);
	jQuery('#sortform').submit();
}

//Check/Uncheck all the option of a checkbox inputs
function changeAll(inputName, checkAllElement)
{
    jQuery('input[name='+inputName+']').each(function(index){jQuery(this).attr('checked', checkAllElement.checked);});
}