﻿dojo.provide("dojo.enabu");
dojo.provide("dojo.enabu.shop");
    
dojo.declare("dojo.enabu.shop.Cart", null, {
    _redirectUrl : '',
    _shopButton : {},
    _inCartButton : null,
    fastCheckOut : false,

    constructor : function(params){
        dojo.mixin(this, params);
    },    		
		
    setRedirectUrl : function(redirectUrl) {
    	this._redirectUrl = redirectUrl;
    },
    
    updateProductQty : function(idProduct) {
    	var textElement = dojo.byId('qtyText_' + idProduct);
    	if(textElement != null) {
            // Si prepara l'oggetto contenente i dati da inviare al controller
            var paramsObject = new Object();
            paramsObject['idProduct'] = idProduct;
            paramsObject['qty'] = textElement.value;
            paramsObject['redirectUrl'] = this._redirectUrl;
            var jsonString = dojo.toJson(paramsObject);
            var params = '?params=' + encodeURIComponent(jsonString);

            // Si esegue la chiamata passando come parametri i 2 metodi di gestione delle risposte
            var url = dojo.enabu.main.baseUrl + 'shop/cart/update';
            window.location = url + params;
    	}
    },

    removeProduct : function(idProduct) {
        // Si prepara l'oggetto contenente i dati da inviare al controller
        var paramsObject = new Object();
        paramsObject['idProduct'] = idProduct;
        paramsObject['redirectUrl'] = this._redirectUrl;
        var jsonString = dojo.toJson(paramsObject);
        var params = '?params=' + encodeURIComponent(jsonString);

        // Si esegue la chiamata passando come parametri i 2 metodi di gestione delle risposte
        var url = dojo.enabu.main.baseUrl + 'shop/cart/remove';
        window.location = url + params;
    },

    toggleShopButton : function(idButton) {
        // Si prepara l'oggetto contenente i dati da inviare al controller
        var shopButtonId = "shopbutton" + idButton;
        var shopButton = dojo.query("#" + shopButtonId)[0];
        if (dojo.hasClass(shopButtonId, "btn")) {
            this._shopButton = dojo.clone(shopButton);
            var shopButtonLink = dojo.query("a", dojo.byId(shopButtonId))[0];
            var shopButtonLabel = dojo.query("span.shopButtonLabel", shopButtonLink)[0];
            dojo.place("<span>In Carrello</span>", shopButtonLabel, "replace");
            shopButtonLink.href = dojo.enabu.main.baseUrl + 'shop/viewcart';
            shopButtonLink.attributes.onclick.value = '';
            dojo.query("#" + shopButtonId).replaceClass("btn_checkout", "btn");
        } else if (dojo.hasClass(shopButtonId, "btn_checkout")) {
            dojo.byId(shopButtonId).innerHTML = this._shopButton.innerHTML;
            dojo.query("#" + shopButtonId).replaceClass("btn", "btn_checkout");
        }
    },

    addProduct : function(idProduct, redirectUrl) {
    	// Si prepara l'oggetto contenente i dati da inviare al controller
    	var paramsObject = new Object();
    	paramsObject['idProduct'] = idProduct;
        paramsObject['redirectUrl'] = (redirectUrl != null) ? redirectUrl : this._redirectUrl;
    	var jsonString = dojo.toJson(paramsObject);
    	var params = '?params=' + encodeURIComponent(jsonString);
    	
    	// Si esegue la chiamata passando come parametri i 2 metodi di gestione delle risposte
    	var url = dojo.enabu.main.baseUrl + 'shop/cart/add';
    	window.location = url + params;
    },

    ajaxAddProduct : function(idProduct) {
        // Si esegue la chiamata passando come parametri i 2 metodi di gestione delle risposte
        var url = dojo.enabu.main.baseUrl + 'shop/cart/ajaxadd';
        var paramsObject = new Object();
        paramsObject['idProduct'] = idProduct;
        var args = {
            content: {
                params: dojo.toJson(paramsObject)
            },
            load : dojo.hitch(this, this.addHandleLoad), 
            error : dojo.hitch(this, this.addHandleError), 
            handleAs : 'json', 
            url : url
        };
        dojo.xhrPost(args);
    },

    addHandleLoad : function(o, ioargs) {
        if (!o.success) {
            this.addHandleError(o, ioargs);
        } else {
            if (dojo.byId("wrapperCartBoxWidget")) {
                dojo.place(o.values.cart, "wrapperCartBoxWidget", "replace");
            } else {
                dojo.place(o.values.cart, dojo.body(), "last");
            }
            if (dojo.byId("nav-cart-count") && o.values.count) {
                dojo.byId("nav-cart-count").innerHTML = o.values.count;
            }
            if (this.fastCheckOut) {
                window.location.replace(dojo.enabu.main.baseUrl + 'shop/viewcart');
            }
        }
    },

    addHandleError : function(o, ioargs) {
        var params = dojo.fromJson(ioargs.args.content.params);
        var idProduct = params.idProduct;
        var idButton = idProduct.substring(idProduct.lastIndexOf(":")+1);
        this.toggleShopButton(idButton);
    },
    
    emptyCart : function() {
    	alert('Svuoto il carrello');
    },
    
    submitOrder: function() {
        window.location = dojo.enabu.main.baseUrl + 'shop/cart/sendorder'; 
    }, 
    
    submitPandoraOrder: function() {
        var paymentMethod = dojo.attr(dojo.query('input[type=radio]:checked', dojo.byId('checkout-payment'))[0], 'value');
        window.location = dojo.enabu.main.baseUrl + 'shop/cart/sendorder/payment/' + paymentMethod;
    },
    
    goToPayChoice: function() {
    	window.location = dojo.enabu.main.baseUrl + 'shop/cart/paychoice';
    },
    
    goToCustomerInfo: function() {
    	window.location = dojo.enabu.main.baseUrl + 'shop/cart/customerinfo';
    },

    goToCustomerCart: function() {
    	window.location = dojo.enabu.main.baseUrl + 'shop/viewcart';
    },
    
    goToCartSummary: function() {
        window.location = dojo.enabu.main.baseUrl + 'shop/cart/cartsummary';
    }
});
