var getQueryParameterByName = function(name) {
	name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
	var regexS = "[\\?&]" + name + "=([^&#]*)";
	var regex = new RegExp(regexS);
	var results = regex.exec(window.location.search);
	if (results == null)
		return null;
	else
		return decodeURIComponent(results[1].replace(/\+/g, " "));
};

var ebodCookieName = "ebod-cnt";
var lastInitStatusCheck = undefined;

var doInitStatus = function() {
	var now = new Date();
	var doIt = !lastInitStatusCheck || (now.getTime() - lastInitStatusCheck.getTime() > 3000);
	lastInitStatusCheck = now;
	return doIt;
};

var updateToolbarLite = function() {
	var sourcesInBook = $.cookie(ebodCookieName);
	if (sourcesInBook) {
		if (sourcesInBook != $("#ebod-tl-sourcesInBook").text()) {
			$("#ebod-tl-sourcesInBook").text(sourcesInBook);
			if (parseInt(sourcesInBook, 10) > 0) {
				$(".toolbarEbookMini").addClass("full");
			} else {
				$(".toolbarEbookMini").removeClass("full");
			}
		}
	} else {
		if ("0" != $("#ebod-tl-sourcesInBook").text()) {
			$("#ebod-tl-sourcesInBook").text(0);
			$(".toolbarEbookMini").removeClass("full");
		}
	}
};

var initToolbarLiteStatus = function() {
	if ($.cookie(ebodCookieName)) {
		if (doInitStatus()) {
			$.ajax({
				type : "GET",
				url : "../api/toolbar/lite/",
				cache : false,
				dataType : "text",
				statusCode : {
					200 : function(sourcesCount) {
						$.cookie(ebodCookieName, sourcesCount);
						$("#ebod-tl-sourcesInBook").text(sourcesCount);
						if (parseInt(sourcesCount, 10) > 0) {
							$(".toolbarEbookMini").addClass("full");
						} else {
							$(".toolbarEbookMini").removeClass("full");
						}
					}
				},
				error : function(xhr) {
					try {
						console.log("error " + xhr.responseText);
					} catch (err) {
					}
				}
			});
		}
	} else {
		$("#ebod-tl-sourcesInBook").text(0);
		$(".toolbarEbookMini").removeClass("full");
	}
};

var initToolbarLite = function() {
	initToolbarLiteStatus();
	setInterval("updateToolbarLite();", 3000);
};

var updateToolbarFull = function() {
	var count = parseInt($("#book-count").text(), 10);
	if (count > 0) {
		$(".ebookCart").html("<a href=\"" + $("#goToEbookConf").attr("href") + "\">" + $(".ebookCart").html() + "</a>");
	}
	var maxSourcesPerBook = parseInt($("#book-max-full").attr("title"), 10);
	if (maxSourcesPerBook > 0 && count >= maxSourcesPerBook && $("#book-add:visible").length > 0) {
		$("#li-book-add, #book-max-full").toggle();
	}
};

var initToolbarFullStatus = function() {
	var sourceUrl = getQueryParameterByName("u");
	if ($.cookie(ebodCookieName)) {
		if (doInitStatus()) {
			$.ajax({
				type : "GET",
				url : "../api/toolbar/full/",
				data : {
					u : sourceUrl
				},
				dataType : "json",
				cache : false,
				statusCode : {
					200 : function(response) {
						$("#book-max-full").attr("title", response.maxSourcesPerBook);
						$("#book-count").text(response.sourcesInBookCount);
						if (response.sourcesInBookCount > 0) {
							$(".toolbarEbook").addClass("full");
							$("#book-add").text("AGGIUNGI AL TUO EBOOK");
						} else {
							$(".toolbarEbook").removeClass("full");
						}
						if (response.sourceInBook) {
							$("#li-book-add").css("display", "none");
							$("#book-added").css("display", "inline-block");
						} else {
							$("#book-added").css("display", "none");
							$("#li-book-add").css("display", "inline-block");
						}
						updateToolbarFull();
					}
				},
				error : function(xhr) {
					try {
						console.log("error " + xhr.responseText);
					} catch (err) {
					}
				}
			});
		}
	} else {
		$("#book-max-full").attr("title", 0);
		$("#book-count").text(0);
		$("#book-added").css("display", "none");
		$("#li-book-add").css("display", "inline-block");
	}
};

var initToolbarFull = function() {
	initToolbarFullStatus();
	var sourceUrl = getQueryParameterByName("u");
	var sourceTitle = getQueryParameterByName("t");
	var sourceSubtitle = getQueryParameterByName("s");
	$("#book-add").click(function() {
		$.ajax({
			type : "PUT",
			url : "../api/book-source/",
			data : JSON.stringify({
				title : sourceTitle,
				subtitle : sourceSubtitle,
				url : sourceUrl
			}),
			contentType : "application/json",
			dataType : "json",
			statusCode : {
				200 : function(data) {
					$.cookie(ebodCookieName, data.sourcesCount);
					$("#book-count").text(data.sourcesCount);
					$("#li-book-add, #book-added").toggle();
					$(".toolbarEbook").addClass("full");
					updateToolbarFull();
					try {
						_gaq.push([ '_trackEvent', 'EBOD', 'added-source', sourceUrl ]);
					} catch (err) {
					}
					if (data.first) {
						window.top.location.href = $("#goToEbookConf").attr("href");
					}
				},
				406 : function() {
					try {
						console.log("error: MaxSourcesPerBookException");
					} catch (err) {
					}
				}
			},
			error : function(xhr) {
				try {
					console.log("error " + xhr.responseText);
				} catch (err) {
				}
			}
		});
	});
};